chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "updateChatTitle" && request.url && request.url.includes("/app/")) {
    saveOrUpdateChat(request.url, request.title);
  }
});

function saveOrUpdateChat(url, rawTitle) {
  chrome.storage.local.get({ savedChats: [] }, (result) => {
    let chats = result.savedChats;
    
    // ניקוי הכותרת
    const cleanTitle = rawTitle.replace("- Gemini", "").replace("Gemini -", "").trim();
    if (!cleanTitle) return;

    const existingIndex = chats.findIndex(chat => chat.url === url);

    if (existingIndex > -1) {
      // אם השיחה קיימת, נעדכן רק אם הכותרת השתנתה או התאריך
      // זה מקפיץ את השיחה לראש הרשימה כי היא פעילה עכשיו
      const existingChat = chats[existingIndex];
      
      // מעדכנים רק אם הכותרת שונה או עבר זמן
      chats.splice(existingIndex, 1); // מוציאים מהמיקום הנוכחי
      
      chats.unshift({
        ...existingChat,
        title: cleanTitle, // עדכון כותרת עדכנית
        timestamp: Date.now() // עדכון זמן אחרון שנצפה
      });

    } else {
      // שיחה חדשה לגמרי
      chats.unshift({
        url: url,
        title: cleanTitle,
        timestamp: Date.now(),
        isEdited: false // דגל אם המשתמש ערך ידנית את הכותרת בעבר
      });
    }

    // שמירה ומגבלה (למשל נשמור רק את ה-200 האחרונות כדי לא להכביד)
    if (chats.length > 200) chats = chats.slice(0, 200);
    
    chrome.storage.local.set({ savedChats: chats });
  });
}